import { View, Text, Pressable } from "react-native";
import React from "react";
import { searchFilter2Style } from "./searchFilter2Style";
import { useNavigation } from "@react-navigation/native";
import { ProductsStyle } from "../../Home/FeaturedProducts/featureProductsStyle";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import CustomRating from "../../Utilities/CustomRating/CustomRating";
import { memo } from "react";
import { PRODUCT_DETAILS } from "../../../components/Navigation/RouteNames";

const SingleListView = ({ item }) => {
    const navigation = useNavigation();
    const productsStyle = ProductsStyle();
    return (
        <Pressable
            style={searchFilter2Style.container}
            onPress={() => {
                navigation.navigate(PRODUCT_DETAILS, {
                    slug: item?.slug,
                    item
                });
            }}
        >
            <View
                style={[
                    productsStyle.imageContainer,
                    searchFilter2Style.imageCont,
                ]}
            >
                <ProgressiveImage
                    source={{ uri: item?.featured_image }}
                    style={productsStyle.img}
                />
            </View>

            <View>
                <CustomRating
                    rating={Number(item?.review_average)}
                    readOnly={true}
                    starSize={dpr(18)}
                    starStyle={productsStyle.start_mr}
                />
                <Text
                    style={[productsStyle.text, searchFilter2Style.text]}
                    numberOfLines={2}
                >
                    {item.name}
                </Text>
                <Text style={productsStyle.price}>
                    {item.regular_price_formatted}
                </Text>
            </View>
        </Pressable>
    );
};

export default memo(SingleListView);
